package com.ejie.ab18a.service;

import com.ejie.ab18a.dao.Ab18aTipoPeticionDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aTipoPeticion;

/**
 * Ab18a02s00ServiceImpl generated by XXXX, 03-feb-2017 12:08:05.
 * 
 * @author XXXX
 */

@Service(value = "ab18a02s00Service")
public class Ab18aTipoPeticionServiceImpl implements Ab18aTipoPeticionService {

	@Autowired
	private Ab18aTipoPeticionDao tipoPeticionDao;

	/**
	 * Inserts a single row in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18aTipoPeticion
	 * @return Ab18aTipoPeticion
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aTipoPeticion add(Ab18aTipoPeticion tipoPeticion) throws Exception {
		return this.tipoPeticionDao.add(tipoPeticion);
	}

	/**
	 * Updates a single row in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18aTipoPeticion
	 * @return Ab18aTipoPeticion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aTipoPeticion update(Ab18aTipoPeticion tipoPeticion) {
		return this.tipoPeticionDao.update(tipoPeticion);
	}

	/**
	 * Finds a single row in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18aTipoPeticion
	 * @return Ab18aTipoPeticion
	 */
	public Ab18aTipoPeticion find(Ab18aTipoPeticion tipoPeticion) {
		return (Ab18aTipoPeticion) this.tipoPeticionDao.find(tipoPeticion);
	}

	/**
	 * Deletes a single row in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18aTipoPeticion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Ab18aTipoPeticion tipoPeticion) {
		this.tipoPeticionDao.remove(tipoPeticion);
	}

	/**
	 * Finds a list of rows in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18aTipoPeticion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18aTipoPeticion>
	 */
	public List<Ab18aTipoPeticion> findAll(Ab18aTipoPeticion tipoPeticion, JQGridRequestDto jqGridRequestDto) {
		return (List<Ab18aTipoPeticion>) this.tipoPeticionDao.findAll(tipoPeticion, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab18a02s00 table using like.
	 * 
	 * @param tipoPeticion
	 *            Ab18aTipoPeticion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18aTipoPeticion>
	 */
	public List<Ab18aTipoPeticion> findAllLike(Ab18aTipoPeticion tipoPeticion, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Ab18aTipoPeticion>) this.tipoPeticionDao.findAllLike(tipoPeticion, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab18a02s00 table.
	 * 
	 * @param filterAb18aTipoPeticion
	 *            Ab18aTipoPeticion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Ab18aTipoPeticion filterAb18aTipoPeticion, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.tipoPeticionDao.removeMultiple(filterAb18aTipoPeticion, jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab18a02s00 table.
	 * 
	 * @param filterAb18aTipoPeticion
	 *            Ab18aTipoPeticion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Ab18aTipoPeticion>
	 */
	public JQGridResponseDto<Ab18aTipoPeticion> filter(Ab18aTipoPeticion filterAb18aTipoPeticion, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<Ab18aTipoPeticion> listaAb18aTipoPeticion = this.tipoPeticionDao.findAllLike(filterAb18aTipoPeticion, jqGridRequestDto, false);
		Long recordNum = this.tipoPeticionDao.findAllLikeCount(filterAb18aTipoPeticion != null ? filterAb18aTipoPeticion : new Ab18aTipoPeticion(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Ab18aTipoPeticion>> reorderSelection = this.tipoPeticionDao.reorderSelection(filterAb18aTipoPeticion, jqGridRequestDto,
					startsWith);
			return new JQGridResponseDto<Ab18aTipoPeticion>(jqGridRequestDto, recordNum, listaAb18aTipoPeticion, reorderSelection);
		}
		return new JQGridResponseDto<Ab18aTipoPeticion>(jqGridRequestDto, recordNum, listaAb18aTipoPeticion);
	}

	/**
	 * Searches rows in the Ab18a02s00 table.
	 * 
	 * @param filterAb18aTipoPeticion
	 *            Ab18aTipoPeticion
	 * @param searchAb18aTipoPeticion
	 *            Ab18aTipoPeticion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18aTipoPeticion>>
	 */
	public List<TableRowDto<Ab18aTipoPeticion>> search(Ab18aTipoPeticion filterAb18aTipoPeticion, Ab18aTipoPeticion searchAb18aTipoPeticion,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tipoPeticionDao.search(filterAb18aTipoPeticion, searchAb18aTipoPeticion, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab18a02s00 table.
	 * 
	 * @param filterAb18aTipoPeticion
	 *            Ab18aTipoPeticion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Ab18aTipoPeticion filterAb18aTipoPeticion, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tipoPeticionDao.reorderSelection(filterAb18aTipoPeticion, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab18a02s00 table.
	 * 
	 * @param filterAb18aTipoPeticion
	 *            Ab18aTipoPeticion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Ab18aTipoPeticion>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aTipoPeticion>> jerarquia(Ab18aTipoPeticion filterAb18aTipoPeticion, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Ab18aTipoPeticion>> listaAb18aTipoPeticion = this.tipoPeticionDao.findAllLikeJerarquia(filterAb18aTipoPeticion,
				jqGridRequestDto);
		Long recordNum = this.tipoPeticionDao.findAllLikeCountJerarquia(filterAb18aTipoPeticion, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Ab18aTipoPeticion>>(jqGridRequestDto, recordNum, listaAb18aTipoPeticion);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab18a02s00 table.
	 * 
	 * @param filterAb18aTipoPeticion
	 *            Ab18aTipoPeticion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Ab18aTipoPeticion>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aTipoPeticion>> jerarquiaChildren(Ab18aTipoPeticion filterAb18aTipoPeticion,
			JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Ab18aTipoPeticion>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Ab18aTipoPeticion>>();
		jqGridResponseDto
				.addAdditionalParam(JQGridResponseDto.CHILDREN, this.tipoPeticionDao.findAllChild(filterAb18aTipoPeticion, jqGridRequestDto));
		return jqGridResponseDto;
	}

	@Override
	public Long findAllCount(Ab18aTipoPeticion tipoPeticion) {
		return this.tipoPeticionDao.findAllCount(tipoPeticion);
	}

	@Override
	public Long findAllLikeCount(Ab18aTipoPeticion tipoPeticion, boolean b) {
		return this.tipoPeticionDao.findAllLikeCount(tipoPeticion, b);
	}

	@Override
	public long findTipoEnvioByCod(String codEnvio) {
		return this.tipoPeticionDao.findTipoEnvioByCod(codEnvio);
	}

}
